/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cmsc420project4;

import java.util.LinkedList;
import java.util.Queue;

/**
 *
 * @author Jeremiah
 */
public class Formula implements Cell
{

    private String formulaString;
    private Operator formulaObject;
    private Queue<DirectedNode> cells;
    private Controller control;

    Formula(String formula, Controller parent)
    {
	formulaString = formula;
	ExpressionTree myTree = new ExpressionTree();
	formulaObject = myTree.parseString(formulaString);
	cells = new LinkedList<DirectedNode>();
	control = parent;
    }

    public void setFormula(String formula)
    {
	formulaString = formula;
	ExpressionTree myTree = new ExpressionTree();
	formulaObject = myTree.parseString(formulaString);
    }

    public String getFormulaString()
    {
	return formulaString;
    }

    public Operator getFormula()
    {
	return formulaObject;
    }

    // Computes result of formula in formulaObject.
    public Double getResult()
    {
	System.out.println("Equation: " + formulaObject.printTree());
	return computeResult(formulaObject);
    }

    public String getResultString()
    {
	Double result = computeResult(formulaObject);
	return Double.toString(result);
//	switch (result.getType())
//	{
//	    case NULL:
//		return "";
//	    case NUMERICAL:
//		return ((Double) result.getData()).toString();
//	    case REFERENCE:
//		return result.getData().toString();
//	    case STRING:
//		return result.getData().toString();
//	    case FORMULA:
//		return result.getData().toString();
//	    case FUNCTION:
//		return result.getData().toString();
//	    default:
//		throw new RuntimeException("Invalid result: " + result.getClass().getCanonicalName());
//	}
    }
    // Computes result of formula recursively.

    private Double computeResult(Operator op)
    {
//	Node leftNode = op.getLeft();
//	Node rightNode = op.getRight();
//
//	Result leftResult;
//	Result rightResult;
	Double result = Double.NaN;

	System.out.println("Computing: " + op.printTree());

	Double leftNum;
	Double rightNum;

	if (op.isLeaf())
	{
	    Double returnNum;
	    // Current op is a leaf - probably a number by itself.
	    try
	    {
		returnNum = Double.parseDouble(op.getData());
	    } catch (NumberFormatException e)
	    {
		// Likely a reference
		CellReference ref = new CellReference(op.getData());
		returnNum = control.getCellResult(ref.getX(), ref.getY());
	    }
	    return returnNum;
	}

	if (op.getLeft().isLeaf())
	{
	    if (op.getRight().isLeaf())
	    {

		// Both are leaves; perform operation.
		// First, check if they are numerical or reference
		try
		{
		    leftNum = Double.parseDouble(op.getLeft().getData());
		} catch (NumberFormatException e)
		{
		    // Likely a reference
		    CellReference ref = new CellReference(op.getLeft().getData());
		    leftNum = control.getCellResult(ref.getX(), ref.getY());
		}

		try
		{
		    rightNum = Double.parseDouble(op.getRight().getData());
		} catch (NumberFormatException e)
		{
		    // Likely a reference
		    CellReference ref = new CellReference(op.getRight().getData());
		    rightNum = control.getCellResult(ref.getX(), ref.getY());
		}

		if (op.getData().equals("+"))
		{
		    System.out.println(leftNum + "+" + rightNum);
		    result = leftNum + rightNum;
		} else if (op.getData().equals("-"))
		{
		    result = leftNum - rightNum;
		} else if (op.getData().equals("*"))
		{
		    result = leftNum * rightNum;
		} else if (op.getData().equals("/"))
		{
		    result = leftNum / rightNum;
		} else if (op.getData().equals("^"))
		{
		    result = Math.pow(leftNum, rightNum);
		}

		return result;
	    } else
	    {
		// Right op is not leaf
		rightNum = computeResult((Operator) op.getRight());
	    }
	} else
	{
	    // Left op is not leaf
	    leftNum = computeResult((Operator) op.getLeft());

	}

	try
	{
	    leftNum = Double.parseDouble(op.getLeft().getData());
	} catch (NumberFormatException e)
	{
	    // Likely a reference
	    CellReference ref = new CellReference(op.getLeft().getData());
	    leftNum = control.getCellResult(ref.getX(), ref.getY());
	}

	try
	{
	    rightNum = Double.parseDouble(op.getRight().getData());
	} catch (NumberFormatException e)
	{
	    // Likely a reference
	    CellReference ref = new CellReference(op.getRight().getData());
	    rightNum = control.getCellResult(ref.getX(), ref.getY());
	}

	if (op.getData().equals("+"))
	{
	    result = leftNum + rightNum;
	} else if (op.getData().equals("-"))
	{
	    result = leftNum - rightNum;
	} else if (op.getData().equals("*"))
	{
	    result = leftNum * rightNum;
	} else if (op.getData().equals("/"))
	{
	    result = leftNum / rightNum;
	} else if (op.getData().equals("^"))
	{
	    result = Math.pow(leftNum, rightNum);
	}

	return result;
	// Binary operations
//	if (op.getData().equals("+") || op.getData().equals("-") || op.getData().equals("*") || op.getData().equals("/") || op.getData().equals("^"))
//	{
//	    op.setLeft(computeResult(op.getLeft()));
//	    op.setRight(computeResult(op.getRight()));
//
//	}

    }
//	if (leftNode instanceof Operator)
//	{
//	    System.out.println("Operation " + ((Operator) leftNode).getOperation() + " equation " + ((Operator) leftNode).printTree());
//	    leftResult = computeResult((Operator) leftNode);
//	} else if (leftNode instanceof Operand)
//	{
//	    leftResult = computeResult((Operand) leftNode);
//	} else if (leftNode == null)
//	{
//	    leftResult = new Result(Result.ResultTypes.NULL);
//	} else
//	{
//	    throw new RuntimeException("Unknown Node type" + leftNode.getClass().getCanonicalName());
//	}
//
//	if (rightNode instanceof Operator)
//	{
//	    System.out.println("Operation " + ((Operator) rightNode).getOperation() + " equation " + ((Operator) rightNode).printTree());
//	    rightResult = computeResult((Operator) rightNode);
//	} else if (rightNode instanceof Operand)
//	{
//	    rightResult = computeResult((Operand) rightNode);
//	} else if (rightNode == null)
//	{
//	    rightResult = new Result(Result.ResultTypes.NULL);
//	} else
//	{
//	    throw new RuntimeException("Unknown Node type" + rightNode.getClass().getCanonicalName());
//	}
//
//	if (leftResult.getType() == Result.ResultTypes.NUMERICAL && rightResult.getType() == Result.ResultTypes.NUMERICAL)
//	{
//	    Double lResult = (Double) leftResult.getData();
//	    Double rResult = (Double) rightResult.getData();
//	    Double result = 0.0;
//
//	    if (op.getData().equals("+"))
//	    {
//		System.out.println("Computation: " + lResult + "+" + rResult + "=" + (lResult + rResult));
//		result = lResult + rResult;
//	    } else if (op.getData().equals("-"))
//	    {
//		System.out.println("Computation: " + lResult + "-" + rResult + "=" + (lResult - rResult));
//		result = lResult - rResult;
//	    } else if (op.getData().equals("*"))
//	    {
//		System.out.println("Computation: " + lResult + "*" + rResult + "=" + (lResult * rResult));
//		result = lResult * rResult;
//	    } else if (op.getData().equals("/"))
//	    {
//		System.out.println("Computation: " + lResult + "/" + rResult + "=" + (lResult / rResult));
//		result = lResult / rResult;
//	    } else if (op.getData().equals("^"))
//	    {
//		System.out.println("Computation: " + lResult + "^" + rResult + "=" + Math.pow(lResult, rResult));
//		result = Math.pow(lResult, rResult);
//	    } else
//	    {
//		throw new RuntimeException("Unknown operation: " + op.getData());
//	    }
//
//	    Result<Double> finalResult = new Result<Double>(Result.ResultTypes.NUMERICAL);
//	    finalResult.setData(result);
//	    return finalResult;
//
//	} else if (leftResult.getType() == Result.ResultTypes.NULL || rightResult.getType() == Result.ResultTypes.NULL)
//	{
//	    if (op.getData() != null)
//	    {
//		// If original operation isn't null, return its data.
//		Double numerical;
//		Result result;
//		try
//		{
//
//		    numerical = Double.parseDouble(op.getData());
//		    result = new Result<Double>(Result.ResultTypes.NUMERICAL);
//		    result.setData(numerical);
//		} catch (NumberFormatException e)
//		{
//		    System.out.println("Reference found Left.");
//		    // Not a number, likely a cell reference.
//		    DirectedNode<CellReference> newNode;
//		    newNode = new DirectedNode<CellReference>(new CellReference(op.getData()));
//		    cells.add(newNode);
//		    result = new Result<CellReference>(Result.ResultTypes.REFERENCE);
//		    result.setData(newNode.getData());
//		}
//
//		//Result<String> resultString = new Result<String>(Result.ResultTypes.STRING);
//		//resultString.setData(op.getData());
//		//return resultString;
//		return result;
//	    }
//	    System.out.println("Null return.");
//	    return new Result(Result.ResultTypes.NULL);
//	} else if (leftResult.getType() == Result.ResultTypes.REFERENCE)
//	{
//	    CellReference newRef = new CellReference(((CellReference)leftResult.getData()).asString());
//	    Result result = control.getCellResult(newRef.getX(), newRef.getY());
//	    return result;
//	} else
//	{
//	    // One of the results is non-numerical.
//	    throw new RuntimeException("Result of type " + leftResult.getClass().getCanonicalName() + " (" + leftResult.getType().toString() + ") or " + rightResult.getClass().getCanonicalName() + " (" + rightResult.getType().toString() + ") invalid");
//	}
//}

//private Result
//computeResult(Operand op)
//    {
//	Double numerical;
//	Result
//
//
//
//
//
//result;
//
//
//
//
//
//
//try
//	{
//
//	    numerical = Double.parseDouble(op.getData());
//	    result
//
//
//
//
//
//= new Result<Double>(Result.ResultTypes.NUMERICAL);
//	    result.
//
//setData(numerical);
//
//
//
//
//
//
//} catch (NumberFormatException e)
//	{
//	    System.out.println("Reference found Left.");
//	    // Not a number, likely a cell reference.
//	    DirectedNode<
//
//CellReference> newNode;
//	    newNode
//
//
//
//
//
//= new DirectedNode<CellReference>(new CellReference(op.getData()));
//	    cells.
//
//add(newNode);
//	    result
//
//
//
//
//
//= new Result<CellReference>(Result.ResultTypes.REFERENCE);
//	    result.
//
//setData(newNode.getData());
//
//
//
//
//
//
//}
//
//	return result;
//
//
//
//
//
//
//
//}
//
    public Queue<DirectedNode> getNewReferences()
    {
//        if(cells == null)
//            {
//            getResult();
//        }
	getResult();
	System.out.println("New Reference count: " + cells.size());
	return cells;
    }

    private boolean isOperator(String op)
    {
	if (op.equals("*") || op.equals("/") || op.equals("+") || op.equals("-") || op.equals("^"))
	{
	    return true;
	} else
	{
	    return false;
	}
    }
}
